"use client"
import Image from 'next/image'
import axios from 'axios'
import { useEffect, useState } from 'react';
import parse from 'html-react-parser';
import Link from 'next/link'
import Footer from '../../../components/footer'
import Header from '../../../components/header'
import '../../../globals.css'
import 'bootstrap/dist/css/bootstrap.css'
import { useParams } from 'next/navigation'
import Loader from '../../../components/loader';
import Head from 'next/head'
import { useRouter } from 'next/router';




const Home = ()=>{
const [company,setCompany]=useState([])
const [menu,setMenu]=useState([])
const params = useParams()
const [loaded,setLoaded]= useState(false)
const [hasSlider,setHasSlider]=useState(false)
const router = useRouter();



async function getData(params) {
  if (params?.company) {

    const companyResponse = await axios.get('https://pixelfcty.com/api/projects?populate=deep&filters[companies][name][$eq]='+params.company)
    const companydata = companyResponse.data.data  
    setCompany(companydata)
 
    const menuResponse = await axios.get('https://pixelfcty.com/api/menus?populate=deep&filters[parent]&filters[company][name][$eq]='+params.company)
    const menudata = menuResponse.data.data   
    setMenu(menudata)

  }

}

useEffect(() => { 
  getData(params)
}, [params])
useEffect(() => {
  if (menu.length !== 0 && company) {
    setLoaded(true)
  }
}, [menu,company]);

  return (
    <>
        <Head>
      <title>Aljaber Holding | {params?.company} </title>
    </Head>
    {!loaded?

        <Loader></Loader>
    :
    <main >
            <div className='companyPage'>
      <Header iswhite={hasSlider} menu={menu}/>
      </div>

      <div className="container home-projects mt-10">
        <div className="row">
          {
            company.length!=0?
            company.map(e=>(
              <div key={e.id} className="col-md-4 home-project">
                <Link  href={'/companies/'+params.company+'/projects/'+e['attributes']['name']}>
                  
              <div className="cart">
                <img alt='dd' src={'https://pixelfcty.com'+ e['attributes']['picture']['data']['attributes']['url']} width={200} height={200}></img>
                <h3>{ e['attributes']['name']}</h3>
              </div>
              </Link>
            </div>
             
            )):''
          }


        </div>
      </div>

          <Footer/>
    </main>
        }
        </>
  )
}




export default Home;